(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     72826,       1479]
NotebookOptionsPosition[     70015,       1383]
NotebookOutlinePosition[     70622,       1405]
CellTagsIndexPosition[     70579,       1402]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "\n",
 StyleBox["Z , Randles circuit",
  FontFamily->"Arial",
  FontSize->20]
}], "Title",
 CellChangeTimes->{
  3.475865912414785*^9, {3.475865943298551*^9, 3.475865955268236*^9}, {
   3.4758660429022484`*^9, 3.475866079428337*^9}, {3.475866316276884*^9, 
   3.4758663189490376`*^9}, {3.4899180970833187`*^9, 
   3.4899181046177497`*^9}, {3.521476712575059*^9, 3.5214767156602354`*^9}, {
   3.5214771897083497`*^9, 3.521477193004538*^9}, {3.5218873523293095`*^9, 
   3.5218873564375443`*^9}, {3.570533035842108*^9, 3.5705330403803673`*^9}, 
   3.5705382339774246`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Off", "[", 
    RowBox[{"General", "::", "spell"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4899223475414314`*^9, 3.489922372043833*^9}, {
  3.489922422316708*^9, 3.4899225446377044`*^9}, {3.4899231471981688`*^9, 
  3.489923148842263*^9}, {3.5218889390790663`*^9, 3.521888942727275*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Cdl\"\>", ",", "\<\"Co\"\>", ",", "\<\"Dox\"\>", 
   ",", "\<\"F\"\>", ",", "\<\"lom\"\>", ",", "\<\"lZm\"\>", ",", "\<\"R\"\>",
    ",", "\<\"Rct\"\>", ",", "\<\"Rs\"\>", ",", "\<\"T\"\>", ",", "\<\"Z\"\>",
    ",", "\<\"Z1\"\>", ",", "\<\"Z2\"\>", ",", "\<\"Zf\"\>", 
   ",", "\<\"ZM\"\>", ",", "\<\"Zw\"\>", ",", "\<\"\[Sigma]\"\>", 
   ",", "\<\"\[Omega]\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.4899224480931826`*^9, 3.4899224680093217`*^9}, {
   3.4899225132789106`*^9, 3.489922572867319*^9}, 3.4899227588979597`*^9, 
   3.4899229525470357`*^9, {3.489923150031331*^9, 3.4899231591338515`*^9}, 
   3.4899232103387804`*^9, {3.4899232425756245`*^9, 3.489923428631266*^9}, 
   3.4899235748226275`*^9, 3.489924077427375*^9, 3.4899241356177034`*^9, 
   3.4899242249058104`*^9, {3.4899242571656556`*^9, 3.4899242784588737`*^9}, 
   3.489924406675207*^9, 3.489924454993971*^9, 3.489924529655241*^9, 
   3.4899245705055776`*^9, 3.489924620959463*^9, 3.5214767197844715`*^9, 
   3.521482241373288*^9, 3.5218881575273647`*^9, 3.5218884336581583`*^9, 
   3.521888592062218*^9, 3.521888625525132*^9, 3.5218889436613283`*^9, 
   3.521889196707802*^9, 3.521889326388219*^9, 3.5218896353968935`*^9, 
   3.5218899920282917`*^9, 3.5218901311722507`*^9, 3.52189052996806*^9, 
   3.5218906339220057`*^9, 3.5218909004972534`*^9, 3.5218923925335927`*^9, 
   3.5218924780914865`*^9, 3.52189263061121*^9, 3.521893227968377*^9, 
   3.521902173010004*^9, 3.521904360150101*^9, 3.521905128757063*^9, 
   3.52191141682472*^9, 3.570533733413007*^9, 3.570533910188118*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"\[Sigma]", "=", 
   RowBox[{"R", "*", 
    RowBox[{"T", "/", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["F", "2"], "*", "Co", "*", 
       RowBox[{"Sqrt", "[", "Dox", "]"}]}], ")"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.4756024908337126`*^9, 3.4756025132197514`*^9}, 
   3.475602710568898*^9, 3.4756028164586835`*^9, {3.475604014994418*^9, 
   3.4756040188336377`*^9}, {3.4756041023064117`*^9, 3.475604103042454*^9}, 
   3.4756042857619047`*^9, {3.4758607424280787`*^9, 3.4758607461322904`*^9}, {
   3.4758653363428354`*^9, 3.4758654700724845`*^9}, {3.4758656911581297`*^9, 
   3.475865692438203*^9}, {3.4758657258471136`*^9, 3.475865727415203*^9}, {
   3.4758660945682034`*^9, 3.4758662093987713`*^9}, 3.4758662524252324`*^9, 
   3.4758663224082355`*^9, {3.4758664993513556`*^9, 3.475866500230406*^9}, {
   3.4758665335913143`*^9, 3.47586653421535*^9}, {3.4759198606664486`*^9, 
   3.4759198680258694`*^9}, {3.4899183954853864`*^9, 
   3.4899186045743456`*^9}, {3.4899186811347246`*^9, 3.4899186819507713`*^9}, 
   3.48991949963054*^9, 3.489920529485444*^9, 3.4899208179169416`*^9, 
   3.4899211413724422`*^9, {3.4899227490373955`*^9, 3.4899227507164917`*^9}, {
   3.4899234830853806`*^9, 3.4899234915648656`*^9}, {3.5214767369024506`*^9, 
   3.5214767910695486`*^9}, {3.5218874144458623`*^9, 3.521887421799283*^9}, {
   3.521888146758748*^9, 3.5218881523740697`*^9}, {3.5705330475077753`*^9, 
   3.5705331045800395`*^9}, 3.5705337217633405`*^9, {3.570533914131343*^9, 
   3.5705339276821184`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"R", " ", "T"}], 
  RowBox[{"Co", " ", 
   SqrtBox["Dox"], " ", 
   SuperscriptBox["F", "2"]}]]], "Output",
 CellChangeTimes->{
  3.4758662534972935`*^9, 3.475866335047958*^9, {3.475866502328526*^9, 
   3.4758665393516436`*^9}, 3.4759203266401005`*^9, 3.475925312701287*^9, 
   3.4759254050455685`*^9, 3.4759257188065147`*^9, {3.489918448983446*^9, 
   3.489918465956417*^9}, 3.489918513668146*^9, {3.489918683930885*^9, 
   3.4899186910602922`*^9}, 3.4899195218568115`*^9, {3.489920594466161*^9, 
   3.4899206118071527`*^9}, 3.4899206433429565`*^9, 3.4899206793910184`*^9, 
   3.4899208222991924`*^9, {3.4899208691178703`*^9, 3.489920894582327*^9}, 
   3.489921146848756*^9, 3.4899211805856853`*^9, 3.4899224035076323`*^9, 
   3.4899226322277145`*^9, 3.4899227628171835`*^9, 3.489922955856225*^9, 
   3.489923159211856*^9, 3.4899232103917837`*^9, {3.4899232426286273`*^9, 
   3.489923428688269*^9}, 3.4899235748896313`*^9, 3.4899240812145915`*^9, 
   3.489924135662706*^9, 3.489924224959813*^9, {3.4899242572166586`*^9, 
   3.4899242785008755`*^9}, 3.4899244067312098`*^9, 3.489924455040973*^9, 
   3.4899245297132444`*^9, 3.48992457054958*^9, 3.4899246210314674`*^9, 
   3.5214767923226204`*^9, 3.5214822414692936`*^9, 3.5218874249584637`*^9, 
   3.521888162891671*^9, 3.5218884337381625`*^9, 3.5218885921362224`*^9, 
   3.521888625603137*^9, 3.52188894980468*^9, 3.521889196776806*^9, 
   3.521889326452223*^9, 3.5218896354658976`*^9, 3.521889992102296*^9, 
   3.5218901312592554`*^9, 3.521890530038064*^9, 3.5218906339960103`*^9, 
   3.521890900582258*^9, 3.521892392620598*^9, 3.5218924781654906`*^9, 
   3.521892630713216*^9, 3.521893228041381*^9, 3.521902173234017*^9, 
   3.5219043602741084`*^9, 3.521905128830067*^9, 3.5219114170227313`*^9, {
   3.570533096740591*^9, 3.570533107999235*^9}, 3.5705332918847528`*^9, {
   3.5705337276076746`*^9, 3.57053373608916*^9}, 3.5705339309213037`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zw", "=", 
  RowBox[{"4", "*", 
   RowBox[{"\[Sigma]", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"\[ImaginaryI]", "*", "\[Omega]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5218874289926944`*^9, 3.521887476006384*^9}, {
  3.5218880815430183`*^9, 3.5218880856382523`*^9}, {3.5705331185628395`*^9, 
  3.570533164322457*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", "R", " ", "T"}], 
  RowBox[{"Co", " ", 
   SqrtBox["Dox"], " ", 
   SuperscriptBox["F", "2"], " ", 
   SqrtBox[
    RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]], "Output",
 CellChangeTimes->{
  3.5218874777724843`*^9, 3.5218881664108725`*^9, 3.5218884337651644`*^9, 
   3.5218885921592236`*^9, 3.5218886256331387`*^9, 3.5218889574351163`*^9, 
   3.521889196798807*^9, 3.5218893264732237`*^9, 3.5218896354938993`*^9, 
   3.5218899921302977`*^9, 3.521890131284257*^9, 3.5218905300670657`*^9, 
   3.5218906340210114`*^9, 3.52189090061626*^9, 3.5218923926505995`*^9, 
   3.521892478196492*^9, 3.5218926307522182`*^9, 3.521893228074383*^9, 
   3.5219021732630186`*^9, 3.5219043602991095`*^9, 3.5219051288540688`*^9, 
   3.5219114170507326`*^9, 3.5705331658685455`*^9, 3.570533308689714*^9, {
   3.570533739287343*^9, 3.570533745428694*^9}, 3.5705339331194296`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zf", "=", 
  RowBox[{"Rct", "+", "Zw"}]}]], "Input",
 CellChangeTimes->{{3.489919493284177*^9, 3.489919514409385*^9}, {
  3.489919545036137*^9, 3.4899195457091756`*^9}, {3.4899205360618205`*^9, 
  3.4899205457093725`*^9}, {3.489920600029479*^9, 3.489920601662573*^9}, {
  3.4899206933568172`*^9, 3.4899207059655385`*^9}, {3.489922938429228*^9, 
  3.489922940494346*^9}, {3.4899234965901527`*^9, 3.4899234985572653`*^9}, {
  3.489924026686473*^9, 3.4899240707649937`*^9}, {3.521476802942228*^9, 
  3.5214768260145473`*^9}, {3.5218875214459825`*^9, 3.521887541750144*^9}, {
  3.570533182450494*^9, 3.5705331884978395`*^9}}],

Cell[BoxData[
 RowBox[{"Rct", "+", 
  FractionBox[
   RowBox[{"4", " ", "R", " ", "T"}], 
   RowBox[{"Co", " ", 
    SqrtBox["Dox"], " ", 
    SuperscriptBox["F", "2"], " ", 
    SqrtBox[
     RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]], "Output",
 CellChangeTimes->{{3.4899240733261404`*^9, 3.489924095086385*^9}, 
   3.4899241356907077`*^9, 3.4899242249958153`*^9, {3.48992425724566*^9, 
   3.4899242785248775`*^9}, 3.489924406761212*^9, 3.4899244550659747`*^9, 
   3.4899245297352457`*^9, 3.489924570574581*^9, 3.48992462107047*^9, 
   3.521476830184786*^9, 3.5214822414992957`*^9, 3.521887544764316*^9, 
   3.521888169612056*^9, 3.5218884337941656`*^9, 3.521888592186225*^9, 
   3.52188862566414*^9, 3.5218889628424253`*^9, 3.5218891968228083`*^9, 
   3.5218893264992256`*^9, 3.5218896355229006`*^9, 3.521889992157299*^9, 
   3.521890131309258*^9, 3.5218905300950675`*^9, 3.521890634048013*^9, 
   3.5218909006512623`*^9, 3.5218923926816015`*^9, 3.521892478228494*^9, 
   3.5218926307912207`*^9, 3.521893228108385*^9, 3.52190217329202*^9, 
   3.5219043603261113`*^9, 3.5219051288790703`*^9, 3.5219114170777345`*^9, 
   3.570533189753911*^9, 3.570533311724888*^9, 3.5705337476078186`*^9, 
   3.5705339359775925`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z", "=", 
  RowBox[{"Rs", "+", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "/", "Zf"}], "+", 
      RowBox[{"\[ImaginaryI]", "*", "\[Omega]", "*", "Cdl"}]}], 
     ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5218875514256973`*^9, 3.5218875836395397`*^9}, {
  3.570533199409464*^9, 3.5705332310922756`*^9}}],

Cell[BoxData[
 RowBox[{"Rs", "+", 
  FractionBox["1", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"Rct", "+", 
      FractionBox[
       RowBox[{"4", " ", "R", " ", "T"}], 
       RowBox[{"Co", " ", 
        SqrtBox["Dox"], " ", 
        SuperscriptBox["F", "2"], " ", 
        SqrtBox[
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]], "+", 
    RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}]}]]}]], "Output",
 CellChangeTimes->{3.5218875841585693`*^9, 3.521888171978191*^9, 
  3.521888433818167*^9, 3.5218885922192273`*^9, 3.5218886256921415`*^9, 
  3.521888976312196*^9, 3.52188919684581*^9, 3.5218893265232267`*^9, 
  3.5218896355539026`*^9, 3.5218899921843004`*^9, 3.5218901313352594`*^9, 
  3.5218905301200686`*^9, 3.521890634075015*^9, 3.521890900683264*^9, 
  3.5218923927116027`*^9, 3.521892478267496*^9, 3.521892630833223*^9, 
  3.521893228141387*^9, 3.521902173323022*^9, 3.521904360351113*^9, 
  3.5219051289010715`*^9, 3.521911417106736*^9, 3.5705332337694287`*^9, 
  3.5705333207094016`*^9, 3.5705337503089733`*^9, 3.5705339381647177`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z1", "=", 
  RowBox[{"Re", "[", "Z", "]"}]}]], "Input",
 CellChangeTimes->{{3.5218876162424045`*^9, 3.5218876638301263`*^9}, {
  3.570533328849867*^9, 3.5705333368193226`*^9}}],

Cell[BoxData[
 RowBox[{"Re", "[", 
  RowBox[{"Rs", "+", 
   FractionBox["1", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"Rct", "+", 
       FractionBox[
        RowBox[{"4", " ", "R", " ", "T"}], 
        RowBox[{"Co", " ", 
         SqrtBox["Dox"], " ", 
         SuperscriptBox["F", "2"], " ", 
         SqrtBox[
          RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]], "+", 
     RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}]}]]}], 
  "]"}]], "Output",
 CellChangeTimes->{{3.521887636233548*^9, 3.521887665390216*^9}, 
   3.5218881739133015`*^9, 3.5218884338441687`*^9, 3.5218885922472286`*^9, 
   3.521888625719143*^9, 3.521888981637501*^9, 3.521889196867811*^9, 
   3.521889326557229*^9, 3.521889635581904*^9, 3.5218899922103024`*^9, 
   3.521890131360261*^9, 3.5218905301470704`*^9, 3.521890634101016*^9, 
   3.5218909007182655`*^9, 3.5218923927386045`*^9, 3.5218924782964983`*^9, 
   3.521892630871225*^9, 3.521893228174389*^9, 3.5219021733530235`*^9, 
   3.521904360375114*^9, 3.521905128923073*^9, 3.521911417136738*^9, 
   3.570533337710374*^9, 3.5705337535241575`*^9, 3.570533940532853*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z2", "=", 
  RowBox[{"Im", "[", "Z", "]"}]}]], "Input",
 CellChangeTimes->{{3.5218877942095833`*^9, 3.5218878611264114`*^9}, {
   3.521889067399406*^9, 3.521889067766427*^9}, 3.5218923741515417`*^9, 
   3.521892463383645*^9, {3.5705333436817155`*^9, 3.57053334971506*^9}}],

Cell[BoxData[
 RowBox[{"Im", "[", 
  RowBox[{"Rs", "+", 
   FractionBox["1", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"Rct", "+", 
       FractionBox[
        RowBox[{"4", " ", "R", " ", "T"}], 
        RowBox[{"Co", " ", 
         SqrtBox["Dox"], " ", 
         SuperscriptBox["F", "2"], " ", 
         SqrtBox[
          RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]], "+", 
     RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}]}]]}], 
  "]"}]], "Output",
 CellChangeTimes->{
  3.521887866198701*^9, 3.521888183418845*^9, 3.52188843387117*^9, 
   3.52188859227223*^9, 3.5218886257471447`*^9, {3.52188904316702*^9, 
   3.5218890694795246`*^9}, 3.5218891968918123`*^9, 3.5218893265822306`*^9, 
   3.521889635612906*^9, 3.5218899922373037`*^9, 3.521890131389263*^9, 
   3.521890530177072*^9, 3.5218906341260176`*^9, 3.5218909007512674`*^9, 
   3.5218923927756066`*^9, 3.5218924783335*^9, 3.5218926309102273`*^9, 
   3.5218932282213917`*^9, 3.521902173383025*^9, 3.5219043604031153`*^9, 
   3.521905128949074*^9, 3.52191141717374*^9, 3.5705333514281583`*^9, 
   3.5705337548102307`*^9, 3.5705339434500203`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ZM", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"Z1", "^", "2"}], "+", 
    RowBox[{"Z2", "^", "2"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"lZM", "=", 
  RowBox[{"Log10", "[", "ZM", "]"}]}]}], "Input",
 CellChangeTimes->{{3.521887890915115*^9, 3.521887929190304*^9}, 
   3.5218923814469585`*^9, 3.5218924691589756`*^9, {3.570533364498906*^9, 
   3.5705333800667963`*^9}, {3.570533795154538*^9, 3.570533808598307*^9}, 
   3.5705353116842785`*^9}],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Im", "[", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "4"}], "+", "lom"}]], " ", 
        SuperscriptBox["5", 
         RowBox[{
          RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
       FractionBox["1", 
        RowBox[{"50", "+", 
         FractionBox["168.41461531141317`", 
          SqrtBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"10", "+", 
      RowBox[{"Re", "[", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["2", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "lom"}]], " ", 
          SuperscriptBox["5", 
           RowBox[{
            RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
         FractionBox["1", 
          RowBox[{"50", "+", 
           FractionBox["168.41461531141317`", 
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}]}], ")"}], 
    "2"]}]]], "Output",
 CellChangeTimes->{3.5218879306973906`*^9, 3.521888187048053*^9, 
  3.521888433903172*^9, 3.5218885922992315`*^9, 3.5218886257781467`*^9, 
  3.5218890772979717`*^9, 3.521889196916814*^9, 3.521889326604232*^9, 
  3.5218896356429076`*^9, 3.5218899922683053`*^9, 3.5218901314182644`*^9, 
  3.5218905302070737`*^9, 3.521890634149019*^9, 3.52189090078327*^9, 
  3.521892392806608*^9, 3.521892478362502*^9, 3.5218926309522295`*^9, 
  3.5218932282583933`*^9, 3.521902173415027*^9, 3.521904360433118*^9, 
  3.5219051289750757`*^9, 3.521911417212742*^9, 3.570533382328926*^9, 
  3.5705337565763316`*^9, 3.570533810451413*^9, 3.5705339491663475`*^9, 
  3.5705353170155835`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Im", "[", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["2", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "lom"}]], " ", 
          SuperscriptBox["5", 
           RowBox[{
            RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
         FractionBox["1", 
          RowBox[{"50", "+", 
           FractionBox["168.41461531141317`", 
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"10", "+", 
        RowBox[{"Re", "[", 
         FractionBox["1", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", 
            SuperscriptBox["2", 
             RowBox[{
              RowBox[{"-", "4"}], "+", "lom"}]], " ", 
            SuperscriptBox["5", 
             RowBox[{
              RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
           FractionBox["1", 
            RowBox[{"50", "+", 
             FractionBox["168.41461531141317`", 
              SqrtBox[
               RowBox[{"\[ImaginaryI]", " ", 
                SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}]}], ")"}], 
      "2"]}]], "]"}], 
  RowBox[{"Log", "[", "10", "]"}]]], "Output",
 CellChangeTimes->{3.5218879306973906`*^9, 3.521888187048053*^9, 
  3.521888433903172*^9, 3.5218885922992315`*^9, 3.5218886257781467`*^9, 
  3.5218890772979717`*^9, 3.521889196916814*^9, 3.521889326604232*^9, 
  3.5218896356429076`*^9, 3.5218899922683053`*^9, 3.5218901314182644`*^9, 
  3.5218905302070737`*^9, 3.521890634149019*^9, 3.52189090078327*^9, 
  3.521892392806608*^9, 3.521892478362502*^9, 3.5218926309522295`*^9, 
  3.5218932282583933`*^9, 3.521902173415027*^9, 3.521904360433118*^9, 
  3.5219051289750757`*^9, 3.521911417212742*^9, 3.570533382328926*^9, 
  3.5705337565763316`*^9, 3.570533810451413*^9, 3.5705339491663475`*^9, 
  3.570535317020584*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Omega]", "=", 
  RowBox[{"10", "^", "lom"}]}]], "Input",
 CellChangeTimes->{{3.4899196353693037`*^9, 3.489919635410306*^9}, {
  3.489919769963002*^9, 3.489919835945776*^9}, {3.489920571068823*^9, 
  3.4899205713238373`*^9}, {3.5214769099183464`*^9, 3.521476931950607*^9}, {
  3.5218882012538652`*^9, 3.5218882038460135`*^9}, {3.570533404026167*^9, 
  3.5705334092844677`*^9}}],

Cell[BoxData[
 SuperscriptBox["10", "lom"]], "Output",
 CellChangeTimes->{{3.489919810926345*^9, 3.4899198370458393`*^9}, 
   3.4899206119381604`*^9, 3.4899207942575884`*^9, 3.489920917215621*^9, 
   3.489921188294126*^9, 3.4899226455154743`*^9, 3.4899227708636436`*^9, 
   3.489922976008377*^9, 3.489923159312862*^9, 3.4899232104867887`*^9, {
   3.489923242732633*^9, 3.4899234287852745`*^9}, 3.4899235749976377`*^9, {
   3.489924109752224*^9, 3.489924135753711*^9}, 3.4899242250468187`*^9, {
   3.4899242573066635`*^9, 3.4899242785798807`*^9}, 3.489924406821215*^9, 
   3.489924455129978*^9, 3.4899245297882485`*^9, 3.489924570624584*^9, 
   3.4899246211514745`*^9, 3.521476933353687*^9, 3.5214822415522985`*^9, 
   3.5218882089873075`*^9, 3.521888433933174*^9, 3.521888592323233*^9, 
   3.5218886258101482`*^9, 3.5218890819342375`*^9, 3.5218891969428153`*^9, 
   3.521889326631233*^9, 3.5218896356749096`*^9, 3.5218899922983074`*^9, 
   3.521890131450266*^9, 3.521890530242076*^9, 3.52189063417702*^9, 
   3.5218909008162713`*^9, 3.5218923928376102`*^9, 3.5218924783935037`*^9, 
   3.521892630995232*^9, 3.5218932282923956`*^9, 3.521902173447029*^9, 
   3.5219043604651194`*^9, 3.521905128998077*^9, 3.5219114172507443`*^9, 
   3.570533410778553*^9, 3.5705337630777035`*^9, 3.5705338188328924`*^9, 
   3.570533951350472*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Rs", "=", "10"}], "\[IndentingNewLine]", 
 RowBox[{"Cdl", "=", 
  RowBox[{"20", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "6"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Dox", "=", 
  RowBox[{"1", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "5"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"F", "=", "96485"}], "\[IndentingNewLine]", 
 RowBox[{"T", "=", "298.15"}], "\[IndentingNewLine]", 
 RowBox[{"R", "=", "8.31447"}], "\[IndentingNewLine]", 
 RowBox[{"Co", "=", 
  RowBox[{"2", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "6"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Rct", "=", "50"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5214769560369844`*^9, 3.52147701278323*^9}, {
   3.521888232566656*^9, 3.5218882696857796`*^9}, {3.5218896221991386`*^9, 
   3.521889622998184*^9}, {3.521890121446694*^9, 3.521890122053729*^9}, 
   3.521890523238675*^9, {3.521890625622531*^9, 3.521890626389575*^9}, {
   3.521890896263011*^9, 3.5218908968050423`*^9}, 3.521892611239102*^9, {
   3.5218932213189964`*^9, 3.5218932221010413`*^9}, {3.570533421283154*^9, 
   3.5705335466113224`*^9}, {3.5705336534924355`*^9, 3.5705337131078453`*^9}, 
   3.57053395462766*^9, {3.5705340513631926`*^9, 3.5705340562904744`*^9}}],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{
  3.521477020436668*^9, 3.5214822415943007`*^9, 3.521888273615004*^9, 
   3.521888433971176*^9, 3.5218885923492346`*^9, 3.5218886258461504`*^9, 
   3.5218890865395007`*^9, 3.5218891969658165`*^9, 3.5218893266562347`*^9, 
   3.5218896357099113`*^9, 3.5218899923293085`*^9, 3.521890131485268*^9, 
   3.521890530278078*^9, {3.521890630918834*^9, 3.5218906342060223`*^9}, 
   3.5218909008552732`*^9, 3.521892392872612*^9, 3.5218924784445066`*^9, 
   3.5218926310382347`*^9, 3.521893228336398*^9, 3.521902173482031*^9, 
   3.5219043605011215`*^9, 3.5219051290230784`*^9, 3.5219114173097477`*^9, 
   3.57053350111372*^9, {3.5705335399239397`*^9, 3.5705335503075337`*^9}, {
   3.570533673862601*^9, 3.57053371616002*^9}, 3.5705338217990623`*^9, 
   3.5705339594539356`*^9, {3.570534034163209*^9, 3.5705340576995544`*^9}}],

Cell[BoxData[
 FractionBox["1", "50000"]], "Output",
 CellChangeTimes->{
  3.521477020436668*^9, 3.5214822415943007`*^9, 3.521888273615004*^9, 
   3.521888433971176*^9, 3.5218885923492346`*^9, 3.5218886258461504`*^9, 
   3.5218890865395007`*^9, 3.5218891969658165`*^9, 3.5218893266562347`*^9, 
   3.5218896357099113`*^9, 3.5218899923293085`*^9, 3.521890131485268*^9, 
   3.521890530278078*^9, {3.521890630918834*^9, 3.5218906342060223`*^9}, 
   3.5218909008552732`*^9, 3.521892392872612*^9, 3.5218924784445066`*^9, 
   3.5218926310382347`*^9, 3.521893228336398*^9, 3.521902173482031*^9, 
   3.5219043605011215`*^9, 3.5219051290230784`*^9, 3.5219114173097477`*^9, 
   3.57053350111372*^9, {3.5705335399239397`*^9, 3.5705335503075337`*^9}, {
   3.570533673862601*^9, 3.57053371616002*^9}, 3.5705338217990623`*^9, 
   3.5705339594539356`*^9, {3.570534034163209*^9, 3.570534057717556*^9}}],

Cell[BoxData[
 FractionBox["1", "100000"]], "Output",
 CellChangeTimes->{
  3.521477020436668*^9, 3.5214822415943007`*^9, 3.521888273615004*^9, 
   3.521888433971176*^9, 3.5218885923492346`*^9, 3.5218886258461504`*^9, 
   3.5218890865395007`*^9, 3.5218891969658165`*^9, 3.5218893266562347`*^9, 
   3.5218896357099113`*^9, 3.5218899923293085`*^9, 3.521890131485268*^9, 
   3.521890530278078*^9, {3.521890630918834*^9, 3.5218906342060223`*^9}, 
   3.5218909008552732`*^9, 3.521892392872612*^9, 3.5218924784445066`*^9, 
   3.5218926310382347`*^9, 3.521893228336398*^9, 3.521902173482031*^9, 
   3.5219043605011215`*^9, 3.5219051290230784`*^9, 3.5219114173097477`*^9, 
   3.57053350111372*^9, {3.5705335399239397`*^9, 3.5705335503075337`*^9}, {
   3.570533673862601*^9, 3.57053371616002*^9}, 3.5705338217990623`*^9, 
   3.5705339594539356`*^9, {3.570534034163209*^9, 3.570534057732557*^9}}],

Cell[BoxData["96485"], "Output",
 CellChangeTimes->{
  3.521477020436668*^9, 3.5214822415943007`*^9, 3.521888273615004*^9, 
   3.521888433971176*^9, 3.5218885923492346`*^9, 3.5218886258461504`*^9, 
   3.5218890865395007`*^9, 3.5218891969658165`*^9, 3.5218893266562347`*^9, 
   3.5218896357099113`*^9, 3.5218899923293085`*^9, 3.521890131485268*^9, 
   3.521890530278078*^9, {3.521890630918834*^9, 3.5218906342060223`*^9}, 
   3.5218909008552732`*^9, 3.521892392872612*^9, 3.5218924784445066`*^9, 
   3.5218926310382347`*^9, 3.521893228336398*^9, 3.521902173482031*^9, 
   3.5219043605011215`*^9, 3.5219051290230784`*^9, 3.5219114173097477`*^9, 
   3.57053350111372*^9, {3.5705335399239397`*^9, 3.5705335503075337`*^9}, {
   3.570533673862601*^9, 3.57053371616002*^9}, 3.5705338217990623`*^9, 
   3.5705339594539356`*^9, {3.570534034163209*^9, 3.570534057734557*^9}}],

Cell[BoxData["298.15`"], "Output",
 CellChangeTimes->{
  3.521477020436668*^9, 3.5214822415943007`*^9, 3.521888273615004*^9, 
   3.521888433971176*^9, 3.5218885923492346`*^9, 3.5218886258461504`*^9, 
   3.5218890865395007`*^9, 3.5218891969658165`*^9, 3.5218893266562347`*^9, 
   3.5218896357099113`*^9, 3.5218899923293085`*^9, 3.521890131485268*^9, 
   3.521890530278078*^9, {3.521890630918834*^9, 3.5218906342060223`*^9}, 
   3.5218909008552732`*^9, 3.521892392872612*^9, 3.5218924784445066`*^9, 
   3.5218926310382347`*^9, 3.521893228336398*^9, 3.521902173482031*^9, 
   3.5219043605011215`*^9, 3.5219051290230784`*^9, 3.5219114173097477`*^9, 
   3.57053350111372*^9, {3.5705335399239397`*^9, 3.5705335503075337`*^9}, {
   3.570533673862601*^9, 3.57053371616002*^9}, 3.5705338217990623`*^9, 
   3.5705339594539356`*^9, {3.570534034163209*^9, 3.5705340577375574`*^9}}],

Cell[BoxData["8.31447`"], "Output",
 CellChangeTimes->{
  3.521477020436668*^9, 3.5214822415943007`*^9, 3.521888273615004*^9, 
   3.521888433971176*^9, 3.5218885923492346`*^9, 3.5218886258461504`*^9, 
   3.5218890865395007`*^9, 3.5218891969658165`*^9, 3.5218893266562347`*^9, 
   3.5218896357099113`*^9, 3.5218899923293085`*^9, 3.521890131485268*^9, 
   3.521890530278078*^9, {3.521890630918834*^9, 3.5218906342060223`*^9}, 
   3.5218909008552732`*^9, 3.521892392872612*^9, 3.5218924784445066`*^9, 
   3.5218926310382347`*^9, 3.521893228336398*^9, 3.521902173482031*^9, 
   3.5219043605011215`*^9, 3.5219051290230784`*^9, 3.5219114173097477`*^9, 
   3.57053350111372*^9, {3.5705335399239397`*^9, 3.5705335503075337`*^9}, {
   3.570533673862601*^9, 3.57053371616002*^9}, 3.5705338217990623`*^9, 
   3.5705339594539356`*^9, {3.570534034163209*^9, 3.570534057740557*^9}}],

Cell[BoxData[
 FractionBox["1", "500000"]], "Output",
 CellChangeTimes->{
  3.521477020436668*^9, 3.5214822415943007`*^9, 3.521888273615004*^9, 
   3.521888433971176*^9, 3.5218885923492346`*^9, 3.5218886258461504`*^9, 
   3.5218890865395007`*^9, 3.5218891969658165`*^9, 3.5218893266562347`*^9, 
   3.5218896357099113`*^9, 3.5218899923293085`*^9, 3.521890131485268*^9, 
   3.521890530278078*^9, {3.521890630918834*^9, 3.5218906342060223`*^9}, 
   3.5218909008552732`*^9, 3.521892392872612*^9, 3.5218924784445066`*^9, 
   3.5218926310382347`*^9, 3.521893228336398*^9, 3.521902173482031*^9, 
   3.5219043605011215`*^9, 3.5219051290230784`*^9, 3.5219114173097477`*^9, 
   3.57053350111372*^9, {3.5705335399239397`*^9, 3.5705335503075337`*^9}, {
   3.570533673862601*^9, 3.57053371616002*^9}, 3.5705338217990623`*^9, 
   3.5705339594539356`*^9, {3.570534034163209*^9, 3.5705340577435575`*^9}}],

Cell[BoxData["50"], "Output",
 CellChangeTimes->{
  3.521477020436668*^9, 3.5214822415943007`*^9, 3.521888273615004*^9, 
   3.521888433971176*^9, 3.5218885923492346`*^9, 3.5218886258461504`*^9, 
   3.5218890865395007`*^9, 3.5218891969658165`*^9, 3.5218893266562347`*^9, 
   3.5218896357099113`*^9, 3.5218899923293085`*^9, 3.521890131485268*^9, 
   3.521890530278078*^9, {3.521890630918834*^9, 3.5218906342060223`*^9}, 
   3.5218909008552732`*^9, 3.521892392872612*^9, 3.5218924784445066`*^9, 
   3.5218926310382347`*^9, 3.521893228336398*^9, 3.521902173482031*^9, 
   3.5219043605011215`*^9, 3.5219051290230784`*^9, 3.5219114173097477`*^9, 
   3.57053350111372*^9, {3.5705335399239397`*^9, 3.5705335503075337`*^9}, {
   3.570533673862601*^9, 3.57053371616002*^9}, 3.5705338217990623`*^9, 
   3.5705339594539356`*^9, {3.570534034163209*^9, 3.5705340577465577`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Z1", ",", "Z2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4756034305039873`*^9, 3.4756034317770596`*^9}, {
   3.4756034944846463`*^9, 3.475603513969761*^9}, {3.475603551473906*^9, 
   3.475603587393961*^9}, 3.4756036488824778`*^9, {3.4756036989943438`*^9, 
   3.4756037027855606`*^9}, {3.4756039087223396`*^9, 
   3.4756039240022135`*^9}, {3.475603989492959*^9, 3.475604001249632*^9}, {
   3.475604151650234*^9, 3.4756041615057983`*^9}, {3.475604357794025*^9, 
   3.47560439371408*^9}, {3.475605209794757*^9, 3.4756052162581263`*^9}, {
   3.4756054334265475`*^9, 3.475605473281827*^9}, {3.475605514436181*^9, 
   3.4756055396506233`*^9}, 3.475865811559016*^9, 3.4758664622142315`*^9, 
   3.4899210018204603`*^9, {3.489921220908992*^9, 3.48992123574084*^9}, {
   3.5214770962080016`*^9, 3.521477119023307*^9}, {3.521888419623355*^9, 
   3.5218884200383787`*^9}, {3.521889136119336*^9, 3.521889146198913*^9}, 
   3.521905292455426*^9, 3.521911388120078*^9, {3.5705338870747957`*^9, 
   3.570533898082425*^9}, {3.5705339800831156`*^9, 3.570534005494569*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VF8bAHCkUkmSJSmJsWWfGcvMWB67ZJmxlJSiQpaQPVJKKS2oRJGl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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0., 435.9443569423566}, {-261.28942762242457`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5219021738590527`*^9, 3.5219043608151393`*^9, 3.521905129375098*^9, 
   3.521905294481542*^9, 3.5219114176727686`*^9, 3.5705339009055867`*^9, {
   3.5705339734567366`*^9, 3.570533982628261*^9}, 3.5705340217695*^9, 
   3.5705340653729935`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CurlyPhi]", "=", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"Z2", "/", "Z1"}], "]"}], "*", 
   RowBox[{"180", "/", "\[Pi]"}]}]}]], "Input",
 CellChangeTimes->{{3.5219007065651283`*^9, 3.5219007065841293`*^9}, {
  3.5705340884983163`*^9, 3.5705341365780663`*^9}, {3.5705342253151417`*^9, 
  3.570534229010353*^9}, {3.570535226003378*^9, 3.5705352276364717`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"180", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"Im", "[", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "4"}], "+", "lom"}]], " ", 
         SuperscriptBox["5", 
          RowBox[{
           RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
        FractionBox["1", 
         RowBox[{"50", "+", 
          FractionBox["168.41461531141317`", 
           SqrtBox[
            RowBox[{"\[ImaginaryI]", " ", 
             SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}], 
     RowBox[{"10", "+", 
      RowBox[{"Re", "[", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["2", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "lom"}]], " ", 
          SuperscriptBox["5", 
           RowBox[{
            RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
         FractionBox["1", 
          RowBox[{"50", "+", 
           FractionBox["168.41461531141317`", 
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}]}]], "]"}]}], 
  "\[Pi]"]], "Output",
 CellChangeTimes->{3.5705341416623573`*^9, 3.5705342311404753`*^9, 
  3.570535231352684*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lom", ",", "\[CurlyPhi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4758610857867174`*^9, 3.4758610994945016`*^9}, {
   3.47586139511141*^9, 3.4758614066940727`*^9}, 3.475861522949722*^9, {
   3.475861586262343*^9, 3.475861623062448*^9}, 3.4758639548218164`*^9, {
   3.475864446741953*^9, 3.4758644503101573`*^9}, {3.4758646109663463`*^9, 
   3.4758646390459523`*^9}, {3.4758646771931343`*^9, 3.4758646914299483`*^9}, 
   3.4758665906145754`*^9, 3.4759254965058002`*^9, 3.4899212624123654`*^9, {
   3.4899227056129117`*^9, 3.4899227097861505`*^9}, 3.5214822947193394`*^9, {
   3.521888447014922*^9, 3.521888491815484*^9}, 3.521911393096363*^9, {
   3.5705341597473917`*^9, 3.5705341793945155`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2nk4VF/cAHD7MmMdYyYVQgg19kiYY5mhlJ0kWyhLKS2WELIkkpSyU7ai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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{-6., 6.}, {-46.425999491844166`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.5219021739270563`*^9, 3.5219043608731422`*^9, 
  3.5219051294511027`*^9, 3.5219114177597733`*^9, 3.570534181935661*^9, 
  3.5705342359007473`*^9, 3.5705352363639708`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.521900703764968*^9, 3.5219007037809687`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lom", ",", "lZM"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4758647127111654`*^9, 3.475864726693966*^9}, {
   3.4758648002301717`*^9, 3.475864817174141*^9}, {3.521888509415491*^9, 
   3.5218885326958227`*^9}, 3.5219113972395997`*^9, {3.5705352641465597`*^9, 
   3.570535276547269*^9}, {3.5705353430120707`*^9, 3.5705353473623195`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2Hk01c//B/Brl/XuVwsV2aNIkeUzryQhFBIpu5AWtEiURGiVKAqtJKJF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     "]]}},
  Axes->True,
  AxesOrigin->{0, 1.},
  Method->{},
  PlotRange->{{-6., 6.}, {1.0000075948052214`, 5.226488149153561}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5219021739650583`*^9, 3.521904360913145*^9, 3.5219051295031056`*^9, 
   3.5219114177997756`*^9, 3.5705352794964375`*^9, {3.570535326354118*^9, 
   3.5705353489564104`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$MaxExtraPrecision", "=", "50"}]], "Input",
 CellChangeTimes->{{3.5219006982126503`*^9, 3.5219006982316513`*^9}, {
  3.5219050890617924`*^9, 3.521905100470445*^9}}],

Cell[BoxData["50"], "Output",
 CellChangeTimes->{{3.5219051062477756`*^9, 3.5219051295181065`*^9}, 
   3.521911417815777*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"pore1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lom", ",", "Z1", ",", "Z2", ",", "lZM", ",", "\[CurlyPhi]"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"lom", ",", 
       RowBox[{"-", "2"}], ",", "7", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.48224695415106*^9, 3.4822470058780184`*^9}, 
   3.482247616006916*^9, 3.482249406678336*^9, {3.4899180741550074`*^9, 
   3.489918075995113*^9}, 3.4899212882048407`*^9, {3.4899214747325096`*^9, 
   3.4899214784287205`*^9}, {3.4899218207332993`*^9, 3.489921838733329*^9}, {
   3.4899218689890594`*^9, 3.4899218743173647`*^9}, {3.5214771395024776`*^9, 
   3.521477155727406*^9}, {3.5218885571592216`*^9, 3.5218885778004026`*^9}, {
   3.521888616026589*^9, 3.5218886178476934`*^9}, 3.52188931853577*^9, 
   3.521889982983774*^9, 3.5219051233047514`*^9, {3.5219114029689274`*^9, 
   3.521911407609193*^9}, 3.521911476249119*^9, {3.570535356419838*^9, 
   3.570535388915696*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Randles.txt\>\"", ",", "pore1", ",", "\"\<Table\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.4822493502621098`*^9, 3.482249404502212*^9, {3.5214771654379616`*^9, 
   3.521477166414017*^9}, {3.5214772797595005`*^9, 3.521477280894565*^9}, {
   3.570535395572077*^9, 3.5705353973291774`*^9}}],

Cell[BoxData["\<\"Randles.txt\"\>"], "Output",
 CellChangeTimes->{
  3.4822470588200464`*^9, 3.4822494180059843`*^9, 3.4899206141082845`*^9, 
   3.489921297854392*^9, 3.489921507021356*^9, 3.4899219563290553`*^9, 
   3.4899231604799285`*^9, 3.4899232116098533`*^9, {3.489923243844697*^9, 
   3.4899234299013386`*^9}, 3.489923576874745*^9, 3.489924137500811*^9, 
   3.4899242266079073`*^9, {3.489924259050763*^9, 3.4899242800389633`*^9}, 
   3.48992440848431*^9, 3.489924456798074*^9, 3.4899245311753283`*^9, 
   3.489924572106669*^9, 3.4899246228165693`*^9, 3.521477172796382*^9, 
   3.521477284913795*^9, 3.5214822422093363`*^9, 3.521888435924288*^9, {
   3.521888586032873*^9, 3.521888593822319*^9}, 3.5218886267072*^9, 
   3.5218891977378607`*^9, 3.5218893274762816`*^9, 3.521889636575961*^9, 
   3.521889993244361*^9, 3.52189013240032*^9, 3.52189053118713*^9, 
   3.521890635130075*^9, 3.521890901785327*^9, 3.521892393817666*^9, 
   3.5218924793715596`*^9, 3.521892631782277*^9, 3.5218932292434497`*^9, 
   3.521902174817107*^9, 3.521904361425174*^9, {3.521905116755377*^9, 
   3.521905129597111*^9}, 3.5219114182288003`*^9, 3.5705354057616596`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1902, 918},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{600, 780}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->2.000000238418579,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 586, 13, 233, "Title"],
Cell[CellGroupData[{
Cell[1178, 39, 589, 10, 213, "Input"],
Cell[1770, 51, 1599, 23, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3406, 79, 1574, 26, 103, "Input"],
Cell[4983, 107, 1937, 30, 116, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6957, 142, 354, 8, 60, "Input"],
Cell[7314, 152, 910, 17, 118, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8261, 174, 645, 10, 60, "Input"],
Cell[8909, 186, 1225, 22, 118, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10171, 213, 361, 10, 60, "Input"],
Cell[10535, 225, 1075, 22, 143, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11647, 252, 200, 4, 60, "Input"],
Cell[11850, 258, 1122, 24, 143, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13009, 287, 296, 5, 60, "Input"],
Cell[13308, 294, 1127, 25, 143, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14472, 324, 488, 11, 125, "Input"],
Cell[14963, 337, 1891, 49, 199, "Output"],
Cell[16857, 388, 2048, 52, 227, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18942, 445, 402, 7, 60, "Input"],
Cell[19347, 454, 1327, 19, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20711, 478, 1248, 25, 391, "Input"],
Cell[21962, 505, 864, 12, 85, "Output"],
Cell[22829, 519, 885, 13, 107, "Output"],
Cell[23717, 534, 886, 13, 107, "Output"],
Cell[24606, 549, 865, 12, 85, "Output"],
Cell[25474, 563, 869, 12, 85, "Output"],
Cell[26346, 577, 868, 12, 85, "Output"],
Cell[27217, 591, 888, 13, 107, "Output"],
Cell[28108, 606, 864, 12, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29009, 623, 1243, 21, 86, "Input"],
Cell[30255, 646, 10971, 187, 469, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41263, 838, 395, 8, 86, "Input"],
Cell[41661, 848, 1327, 40, 250, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43025, 893, 886, 16, 86, "Input"],
Cell[43914, 911, 14456, 243, 920, "Output"]
}, Open  ]],
Cell[58385, 1157, 94, 1, 60, "Input"],
Cell[CellGroupData[{
Cell[58504, 1162, 523, 11, 86, "Input"],
Cell[59030, 1175, 8023, 139, 333, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67090, 1319, 188, 3, 60, "Input"],
Cell[67281, 1324, 125, 2, 59, "Output"]
}, Open  ]],
Cell[67421, 1329, 1034, 21, 86, "Input"],
Cell[CellGroupData[{
Cell[68480, 1354, 350, 7, 86, "Input"],
Cell[68833, 1363, 1154, 16, 85, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
